<?php
namespace VM\ApiBundle\DataFixtures\ORM;

use Doctrine\Common\Persistence\ObjectManager;
use Doctrine\Common\DataFixtures\AbstractFixture;
use Doctrine\Common\DataFixtures\OrderedFixtureInterface;
use Import\ApiBundle\Entity\AllegroCategory;
use Import\ApiBundle\Entity\AllegroCategoryItem;
use Import\ApiBundle\Entity\AllegroCategoryItemType;
use Import\ApiBundle\Entity\AllegroUser;
use Symfony\Component\DependencyInjection\ContainerAwareInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;
use VM\AdminBundle\Services\SsoCommunication;
use VM\AdminBundle\Services\TokensGenerator;
use VM\ApiBundle\Entity\Department;
use VM\ApiBundle\Entity\DepartmentAllegroCategoryItem;
use VM\ApiBundle\Entity\DepartmentType;
use VM\ApiBundle\Entity\Employee;
use VM\ApiBundle\Entity\MarketSegment;
use VM\ApiBundle\Entity\Offer;
use VM\ApiBundle\Entity\OfferReport;
use VM\ApiBundle\Entity\User;
use VM\ApiBundle\Entity\UserGroups;
use Import\ApiBundle\Entity\PKD;

class LoadOffers extends AbstractFixture implements OrderedFixtureInterface, ContainerAwareInterface
{
    /**
     * @var ContainerInterface
     */
    private $container;

    /**
     * @var \Doctrine\ORM\EntityManager
     */
    private $EntityManager;


    protected $offers = array(
        //audyty
        array('name'=>'Audyt zewnętrzny','price'=>20000,'efficiency'=>array('BRAKI'=>'20')),
        array('name'=>'Wdrożenie standardu zarządzania jakością ISO 9001','price'=>15000,'efficiency'=>array('BRAKI'=>'20'),'onlyOne'=>true,'childrens'=>array(
            array('price'=>4000,'name'=>'Audyt standardu ISO 9001','efficiency'=>array('BRAKI'=>'50'))
        )),
        array('name'=>'Wdrożenie standardu zarządzania jakością ISO 27001','price'=>17500,'efficiency'=>array('BRAKI'=>'30'),'onlyOne'=>true,'childrens'=>array(
            array('price'=>5000,'name'=>'Audyt standardu ISO 27001','efficiency'=>array('BRAKI'=>'60'))
        )),
        //wzornictwo
        array('name'=>'Usługi studia wzornictwa przemysłowego','price'=>20000,'efficiency'=>array('PIR'=>'0|1.4|0.6','BIR'=>'0|1.4|0.6')),
        array('name'=>'Usługi dużej agencji wzornictwa przemysłowego','price'=>60000,'efficiency'=>array('PIR'=>'0|3.5|1.5','BIR'=>'0|3.5|1.5')),
        //badania konsumentów
        array('name'=>'Ilościowe badanie potrzeb konsumentów','price'=>50000,'efficiency'=>array('xPIR'=>'0|1.7')), //tylko dla książek
        array('name'=>'Jakościowe badanie potrzeb konsumentów','price'=>100000,'efficiency'=>array('xPIR'=>'0|2')),
        //promocja
        array('name'=>'Impreza integracyjna z mieszkańcami gminy','price'=>55000,'efficiency'=>array('PIR'=>'5|3|1')),
        array('name'=>'Reklama w lokalnej prasie','price'=>3000,'efficiency'=>array('PIR'=>'0.5|0.5')),
        array('name'=>'Reklama w prasie ogólnokrajowej','price'=>10000,'efficiency'=>array('PIR'=>'2|1|0.5')),
        array('name'=>'Reklama w radiu','price'=>7000,'efficiency'=>array('PIR'=>'2|1')),
        array('name'=>'Reklama w telewizji lokalnej','price'=>20000,'efficiency'=>array('PIR'=>'3|1')),
        array('name'=>'Reklama w telewizji ogólnokrajowej','price'=>50000,'efficiency'=>array('PIR'=>'5|3|1|0.5')),
        array('name'=>'Reklama w telewizji podczas dużego wydarzenia sportowego lub kulturalnego','price'=>100000,'efficiency'=>array('PIR'=>'7|4|2')),
        array('name'=>'Pozycjonowanie strony firmowej w internecie','price'=>30000,'efficiency'=>array('PIR'=>'4|1')),
        array('name'=>'Kolportaż ulotek na terenie gminy','price'=>5000,'efficiency'=>array('PIR'=>'1')),
        array('name'=>'Kolportaż ulotek w największych miastach kraju','price'=>60000,'efficiency'=>array('PIR'=>'4|1')),
        array('name'=>'Wystawa produktów podczas lokalnych targów technologicznych','price'=>2000,'efficiency'=>array('PIR'=>'1.5|0.5')),
        array('name'=>'Wystawa produktów podczas ogólnokrajowych targów technologicznych','price'=>20000,'efficiency'=>array('PIR'=>'3.5|1.5')),
        //edukacja pracownikow
        array('name'=>'Udział pracowników w lokalnych targach technologicznych','price'=>2500,'efficiency'=>array('BIR'=>'1.5|0.5')),
        array('name'=>'Udział pracowników w ogólnokrajowych targach technologicznych','price'=>4000,'efficiency'=>array('BIR'=>'2|1')),
        array('name'=>'Szkolenie pracowników w zakresie umiejętności zawodowych','price'=>5000,'efficiency'=>array('BIR'=>'2.5|1.5|0.5')),
        array('name'=>'Szkolenie pracowników w zakresie komunikacji interpersonalnej','price'=>7000,'efficiency'=>array('PIR'=>'1.5|0.5', 'BIR'=>'1.5|0.5')),
    );

    /**
     * {@inheritDoc}
     */
    public function setContainer(ContainerInterface $container = null)
    {
        $this->container = $container;
    }


    public function load(ObjectManager $EntityManager)
    {
        $this->EntityManager = $EntityManager;

        foreach($this->offers as $offerData)
        {
            $Offer = $this->createOffer($offerData);
            if(isset($offerData['childrens']))
            {
                foreach($offerData['childrens'] as $childrenData)
                {
                    $children = $this->createOffer($childrenData);
                    $children->setParent($Offer);
                    $Offer->addChildren($children);
                }
            }
        }

        $this->EntityManager->flush();
    }

    /**
     * @param $offerData
     * @return Offer
     */
    private function createOffer($offerData)
    {
        $Offer = new Offer();
        $Offer->setName($offerData['name']);
        $Offer->setPrice($offerData['price']);
        $Offer->setEfficiency(json_encode($offerData['efficiency']));
        if(isset($offerData['onlyOne']))
        {
            $Offer->setOnlyOne($offerData['onlyOne']);
        }

        $this->EntityManager->persist($Offer);

        return $Offer;
    }

    public function getOrder()
    {
        return 3000;
    }
}